#ifdef ALPHATEST

	varying vec2 		texcoords;	
	uniform sampler2D 	tex;
	uniform float 		alphalevel;
	uniform float		alphaMul;
	
	#ifdef PSYSTEM

		varying float 	life;

	#endif

#endif

varying vec2 depth;	

void main()
{
	#ifdef ALPHATEST
		
		#ifdef PSYSTEM
			gl_FragColor.a=texture2D(tex,texcoords.st).a*life;
			if(gl_FragColor.a*alphaMul<=alphalevel)
				discard;
		#else
			gl_FragColor.a=texture2D(tex,texcoords.st).a;
			if(gl_FragColor.a*alphaMul<=alphalevel)
				discard;
		#endif
		
	#endif
	
	gl_FragDepth = (depth.x/depth.y)*0.5 + 0.5;
}
